<?php

use yii\db\Migration;

/**
 * Handles the creation of table `{{%application}}`.
 */
class m251105_151747_create_application_table extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->createTable('{{%application}}', [
            'id' => $this->primaryKey(),
            'id' => $this->primaryKey(),
            'user_id' => $this->integer()->notNull(),
            'date' => $this->date()->notNull(),
            'category' => $this->string()->notNull(), // electricity, gas, water
            'previous_readings' => $this->decimal(10, 2)->notNull(),
            'current_readings' => $this->decimal(10, 2)->notNull(),
            'consumption' => $this->decimal(10, 2)->notNull(),
            'tariff' => $this->decimal(10, 2)->notNull(),
            'amount' => $this->decimal(10, 2)->notNull(),
            'status' => $this->string()->defaultValue('pending'),
            'created_at' => $this->timestamp()->defaultExpression('CURRENT_TIMESTAMP'),
            'updated_at' => $this->timestamp()->defaultExpression('CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP'),
        ]);

        $this->addForeignKey(
            'fk-application-user_id',
            '{{%application}}',
            'user_id',
            '{{%user}}',
            'id',
            'CASCADE',
            'CASCADE'
        );

        $this->createIndex('idx-application-user_id', '{{%application}}', 'user_id');
        $this->createIndex('idx-application-date', '{{%application}}', 'date');
        $this->createIndex('idx-application-status', '{{%application}}', 'status');
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropForeignKey('fk-application-user_id', '{{%application}}');
        $this->dropTable('{{%application}}');
    }
}
