<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\bootstrap5\Alert;

/** @var yii\web\View $this */
/** @var app\models\ReadingForm $model */

$this->title = 'Передача показаний';
$this->params['breadcrumbs'][] = ['label' => 'Мои заявки', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;

$tariffs = [
    'electricity' => 'Электричество: 5,03 руб/ед.',
    'gas' => 'Газ: 7,39 руб/ед.',
    'water' => 'Вода: 48,24 руб/ед.'
];
?>

<div class="application-create">
    <div class="create-container">
        <div class="create-header">
            <div class="header-icon">
                <i class="fas fa-tachometer-alt"></i>
            </div>
            <div class="header-content">
                <h1 class="page-title"><?= Html::encode($this->title) ?></h1>
                <p class="page-subtitle">Передайте текущие показания счетчиков для расчета платежа</p>
            </div>
        </div>

        <div class="create-card">
            <div class="card-body">
                <?php if (Yii::$app->session->hasFlash('success')): ?>
                    <div class="alert-message success">
                        <div class="alert-icon">
                            <i class="fas fa-check-circle"></i>
                        </div>
                        <div class="alert-content">
                            <?= Yii::$app->session->getFlash('success') ?>
                        </div>
                    </div>
                <?php endif; ?>

                <?php if (Yii::$app->session->hasFlash('error')): ?>
                    <div class="alert-message error">
                        <div class="alert-icon">
                            <i class="fas fa-exclamation-circle"></i>
                        </div>
                        <div class="alert-content">
                            <?= Yii::$app->session->getFlash('error') ?>
                        </div>
                    </div>
                <?php endif; ?>

                <div class="tariffs-info">
                    <div class="tariffs-header">
                        <i class="fas fa-info-circle"></i>
                        <h3>Действующие тарифы</h3>
                    </div>
                    <div class="tariffs-grid">
                        <div class="tariff-item">
                            <div class="tariff-icon electricity">
                                <i class="fas fa-bolt"></i>
                            </div>
                            <div class="tariff-content">
                                <span class="tariff-name">Электричество</span>
                                <span class="tariff-price">5,03 руб/ед.</span>
                            </div>
                        </div>
                        <div class="tariff-item">
                            <div class="tariff-icon gas">
                                <i class="fas fa-fire"></i>
                            </div>
                            <div class="tariff-content">
                                <span class="tariff-name">Газ</span>
                                <span class="tariff-price">7,39 руб/ед.</span>
                            </div>
                        </div>
                        <div class="tariff-item">
                            <div class="tariff-icon water">
                                <i class="fas fa-tint"></i>
                            </div>
                            <div class="tariff-content">
                                <span class="tariff-name">Вода</span>
                                <span class="tariff-price">48,24 руб/ед.</span>
                            </div>
                        </div>
                    </div>
                </div>

                <?php $form = ActiveForm::begin([
                    'id' => 'reading-form',
                    'options' => ['class' => 'reading-form']
                ]); ?>

                <div class="form-grid">
                    <div class="form-group">
                        <?= $form->field($model, 'date', [
                            'template' => '
                                <div class="input-group">
                                    <span class="input-icon">
                                        <i class="fas fa-calendar-alt"></i>
                                    </span>
                                    {input}
                                </div>
                                {label}
                                {error}
                            ',
                            'labelOptions' => ['class' => 'form-label'],
                            'inputOptions' => [
                                'class' => 'form-input date-input',
                                'type' => 'date'
                            ]
                        ])->input('date') ?>
                    </div>

                    <div class="form-group">
                        <?= $form->field($model, 'category', [
                            'template' => '
                                <div class="input-group">
                                    <span class="input-icon">
                                        <i class="fas fa-list"></i>
                                    </span>
                                    {input}
                                </div>
                                {label}
                                {error}
                            ',
                            'labelOptions' => ['class' => 'form-label'],
                            'inputOptions' => [
                                'class' => 'form-input select-input',
                                'onchange' => 'this.form.submit()'
                            ]
                        ])->dropDownList(
                            \app\models\Application::getCategories(),
                            [
                                'prompt' => 'Выберите категорию',
                                'onchange' => 'this.form.submit()'
                            ]
                        ) ?>
                    </div>
                </div>

                <?php if ($model->category): ?>
                    <div class="readings-section">
                        <div class="section-header">
                            <h3>Показания счетчика</h3>
                            <div class="category-badge <?= $model->category ?>">
                                <i class="fas fa-<?= $model->category === 'electricity' ? 'bolt' : ($model->category === 'gas' ? 'fire' : 'tint') ?>"></i>
                                <?= \app\models\Application::getCategories()[$model->category] ?>
                            </div>
                        </div>

                        <div class="readings-grid">
                            <div class="reading-group">
                                <?= $form->field($model, 'previous_readings', [
                                    'template' => '
                                        <div class="input-group">
                                            <span class="input-icon">
                                                <i class="fas fa-arrow-left"></i>
                                            </span>
                                            {input}
                                        </div>
                                        {label}
                                        {error}
                                    ',
                                    'labelOptions' => ['class' => 'form-label'],
                                    'inputOptions' => [
                                        'class' => 'form-input readonly-input',
                                        'readonly' => true
                                    ]
                                ])->textInput() ?>
                                <div class="reading-hint">Предыдущее показание</div>
                            </div>

                            <div class="reading-group">
                                <?= $form->field($model, 'current_readings', [
                                    'template' => '
                                        <div class="input-group">
                                            <span class="input-icon">
                                                <i class="fas fa-arrow-right"></i>
                                            </span>
                                            {input}
                                        </div>
                                        {label}
                                        {error}
                                    ',
                                    'labelOptions' => ['class' => 'form-label'],
                                    'inputOptions' => [
                                        'class' => 'form-input current-input',
                                        'placeholder' => 'Введите текущее значение',
                                        'onchange' => 'document.getElementById("calculate-btn").click()'
                                    ]
                                ])->textInput([
                                    'onchange' => 'document.getElementById("calculate-btn").click()'
                                ]) ?>
                                <div class="reading-hint">Текущее показание</div>
                            </div>
                        </div>

                        <?php if ($model->current_readings): ?>
                            <div class="calculation-preview">
                                <div class="calculation-header">
                                    <i class="fas fa-calculator"></i>
                                    <h4>Предварительный расчет</h4>
                                    <?= Html::submitButton('Пересчитать', [
                                        'id' => 'calculate-btn',
                                        'name' => 'action',
                                        'value' => 'calculate',
                                        'class' => 'btn-calculate'
                                    ]) ?>
                                </div>
                                <div class="calculation-grid">
                                    <div class="calculation-item">
                                        <div class="calculation-label">Расход</div>
                                        <div class="calculation-value consumption">
                                            <?= number_format($model->consumption, 2, ',', ' ') ?> ед.
                                        </div>
                                    </div>
                                    <div class="calculation-item">
                                        <div class="calculation-label">Тариф</div>
                                        <div class="calculation-value tariff">
                                            <?= number_format($model->tariff, 2, ',', ' ') ?> руб.
                                        </div>
                                    </div>
                                    <div class="calculation-item">
                                        <div class="calculation-label">Сумма к оплате</div>
                                        <div class="calculation-value amount">
                                            <?= number_format($model->amount, 2, ',', ' ') ?> руб.
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>

                <div class="form-actions">
                    <?= Html::submitButton('<i class="fas fa-paper-plane"></i> Отправить заявку', [
                        'class' => 'btn-submit',
                        'name' => 'action',
                        'value' => 'submit'
                    ]) ?>
                    <?= Html::a('<i class="fas fa-times"></i> Отмена', ['index'], ['class' => 'btn-cancel']) ?>
                </div>

                <?php ActiveForm::end(); ?>
            </div>
        </div>
    </div>
</div>

<style>
    /* Main Container */
    .application-create {
        min-height: 100vh;
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        padding: 2rem 1rem;
    }

    .create-container {
        max-width: 900px;
        margin: 0 auto;
    }

    /* Header */
    .create-header {
        display: flex;
        align-items: center;
        gap: 1.5rem;
        margin-bottom: 2rem;
    }

    .header-icon {
        width: 80px;
        height: 80px;
        background: rgba(255, 255, 255, 0.2);
        backdrop-filter: blur(10px);
        border-radius: 20px;
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        font-size: 2.5rem;
    }

    .header-content {
        flex: 1;
    }

    .page-title {
        font-size: 2.5rem;
        font-weight: 700;
        color: white;
        margin: 0 0 0.5rem 0;
    }

    .page-subtitle {
        color: rgba(255, 255, 255, 0.9);
        font-size: 1.1rem;
        margin: 0;
    }

    /* Card */
    .create-card {
        background: rgba(255, 255, 255, 0.95);
        backdrop-filter: blur(20px);
        border-radius: 24px;
        box-shadow: 0 20px 60px rgba(0, 0, 0, 0.2);
        overflow: hidden;
    }

    .card-body {
        padding: 2.5rem;
    }

    /* Alert Messages */
    .alert-message {
        display: flex;
        align-items: flex-start;
        gap: 1rem;
        padding: 1.25rem;
        border-radius: 12px;
        margin-bottom: 2rem;
    }

    .alert-message.success {
        background: rgba(46, 204, 113, 0.1);
        border: 1px solid rgba(46, 204, 113, 0.3);
        color: #27ae60;
    }

    .alert-message.error {
        background: rgba(231, 76, 60, 0.1);
        border: 1px solid rgba(231, 76, 60, 0.3);
        color: #c0392b;
    }

    .alert-icon {
        font-size: 1.25rem;
        margin-top: 0.125rem;
    }

    .alert-content {
        flex: 1;
    }

    /* Tariffs Info */
    .tariffs-info {
        background: #f8faff;
        border: 1px solid #e8eeff;
        border-radius: 16px;
        padding: 1.5rem;
        margin-bottom: 2rem;
    }

    .tariffs-header {
        display: flex;
        align-items: center;
        gap: 0.75rem;
        margin-bottom: 1rem;
    }

    .tariffs-header i {
        color: #667eea;
        font-size: 1.25rem;
    }

    .tariffs-header h3 {
        margin: 0;
        color: #2c3e50;
        font-size: 1.25rem;
    }

    .tariffs-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
        gap: 1rem;
    }

    .tariff-item {
        display: flex;
        align-items: center;
        gap: 1rem;
        padding: 1rem;
        background: white;
        border-radius: 12px;
        border: 1px solid #e8eeff;
        transition: all 0.3s ease;
    }

    .tariff-item:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(102, 126, 234, 0.15);
    }

    .tariff-icon {
        width: 50px;
        height: 50px;
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 1.5rem;
        color: white;
    }

    .tariff-icon.electricity {
        background: linear-gradient(135deg, #f093fb, #f5576c);
    }

    .tariff-icon.gas {
        background: linear-gradient(135deg, #4facfe, #00f2fe);
    }

    .tariff-icon.water {
        background: linear-gradient(135deg, #43e97b, #38f9d7);
    }

    .tariff-content {
        display: flex;
        flex-direction: column;
    }

    .tariff-name {
        font-weight: 600;
        color: #2c3e50;
        margin-bottom: 0.25rem;
    }

    .tariff-price {
        color: #667eea;
        font-weight: 500;
        font-size: 0.9rem;
    }

    /* Form Styles */
    .form-grid {
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: 1.5rem;
        margin-bottom: 2rem;
    }

    .form-group {
        margin-bottom: 0;
    }

    .input-group {
        position: relative;
        display: flex;
        align-items: center;
    }

    .input-icon {
        position: absolute;
        left: 1rem;
        z-index: 2;
        color: #667eea;
        font-size: 1rem;
    }

    .form-input {
        width: 100%;
        padding: 1rem 1rem 1rem 3rem;
        border: 2px solid #e8eeff;
        border-radius: 12px;
        font-size: 1rem;
        background: #f8faff;
        transition: all 0.3s ease;
        outline: none;
    }

    .form-input:focus {
        border-color: #667eea;
        background: white;
        box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
    }

    .form-input.readonly-input {
        background: #f1f3f4;
        color: #7f8c8d;
        cursor: not-allowed;
    }

    .form-input.current-input {
        background: #fff9e6;
        border-color: #ffd93d;
    }

    .form-input.current-input:focus {
        border-color: #ffd93d;
        box-shadow: 0 0 0 3px rgba(255, 217, 61, 0.1);
    }

    .form-label {
        display: block;
        margin-bottom: 0.5rem;
        font-weight: 600;
        color: #2c3e50;
        font-size: 0.95rem;
    }

    /* Readings Section */
    .readings-section {
        background: #f8faff;
        border: 1px solid #e8eeff;
        border-radius: 16px;
        padding: 2rem;
        margin: 2rem 0;
    }

    .section-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 1.5rem;
    }

    .section-header h3 {
        margin: 0;
        color: #2c3e50;
        font-size: 1.5rem;
    }

    .category-badge {
        display: flex;
        align-items: center;
        gap: 0.5rem;
        padding: 0.5rem 1rem;
        border-radius: 20px;
        font-weight: 600;
        font-size: 0.9rem;
    }

    .category-badge.electricity {
        background: rgba(243, 156, 18, 0.1);
        color: #f39c12;
        border: 1px solid rgba(243, 156, 18, 0.3);
    }

    .category-badge.gas {
        background: rgba(52, 152, 219, 0.1);
        color: #3498db;
        border: 1px solid rgba(52, 152, 219, 0.3);
    }

    .category-badge.water {
        background: rgba(46, 204, 113, 0.1);
        color: #27ae60;
        border: 1px solid rgba(46, 204, 113, 0.3);
    }

    .readings-grid {
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: 1.5rem;
    }

    .reading-group {
        position: relative;
    }

    .reading-hint {
        font-size: 0.875rem;
        color: #7f8c8d;
        margin-top: 0.5rem;
        text-align: center;
    }

    /* Calculation Preview */
    .calculation-preview {
        background: white;
        border: 1px solid #e8eeff;
        border-radius: 12px;
        padding: 1.5rem;
        margin-top: 1.5rem;
    }

    .calculation-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 1rem;
    }

    .calculation-header h4 {
        margin: 0;
        color: #2c3e50;
        display: flex;
        align-items: center;
        gap: 0.5rem;
    }

    .calculation-header i {
        color: #667eea;
    }

    .btn-calculate {
        background: #667eea;
        color: white;
        border: none;
        padding: 0.5rem 1rem;
        border-radius: 8px;
        font-size: 0.875rem;
        cursor: pointer;
        transition: all 0.3s ease;
    }

    .btn-calculate:hover {
        background: #5a6fd8;
        transform: translateY(-1px);
    }

    .calculation-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
        gap: 1rem;
    }

    .calculation-item {
        text-align: center;
        padding: 1rem;
        background: #f8faff;
        border-radius: 8px;
    }

    .calculation-label {
        font-size: 0.875rem;
        color: #7f8c8d;
        margin-bottom: 0.5rem;
    }

    .calculation-value {
        font-weight: 700;
        font-size: 1.1rem;
    }

    .calculation-value.consumption {
        color: #e67e22;
    }

    .calculation-value.tariff {
        color: #667eea;
    }

    .calculation-value.amount {
        color: #27ae60;
        font-size: 1.25rem;
    }

    /* Form Actions */
    .form-actions {
        display: flex;
        gap: 1rem;
        justify-content: flex-end;
        margin-top: 2rem;
        padding-top: 2rem;
        border-top: 1px solid #e8eeff;
    }

    .btn-submit {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
        border: none;
        padding: 1rem 2rem;
        font-size: 1.1rem;
        font-weight: 600;
        border-radius: 12px;
        cursor: pointer;
        transition: all 0.3s ease;
        box-shadow: 0 4px 15px rgba(102, 126, 234, 0.4);
        display: flex;
        align-items: center;
        gap: 0.5rem;
    }

    .btn-submit:hover {
        transform: translateY(-2px);
        box-shadow: 0 8px 25px rgba(102, 126, 234, 0.6);
    }

    .btn-cancel {
        background: white;
        color: #667eea;
        border: 2px solid #667eea;
        padding: 1rem 2rem;
        font-size: 1.1rem;
        font-weight: 600;
        border-radius: 12px;
        cursor: pointer;
        transition: all 0.3s ease;
        text-decoration: none;
        display: flex;
        align-items: center;
        gap: 0.5rem;
    }

    .btn-cancel:hover {
        background: #667eea;
        color: white;
        transform: translateY(-2px);
        text-decoration: none;
    }

    /* Responsive Design */
    @media (max-width: 768px) {
        .create-header {
            flex-direction: column;
            text-align: center;
            gap: 1rem;
        }

        .page-title {
            font-size: 2rem;
        }

        .card-body {
            padding: 1.5rem;
        }

        .form-grid,
        .readings-grid,
        .calculation-grid {
            grid-template-columns: 1fr;
        }

        .tariffs-grid {
            grid-template-columns: 1fr;
        }

        .section-header {
            flex-direction: column;
            gap: 1rem;
            align-items: flex-start;
        }

        .form-actions {
            flex-direction: column;
        }

        .btn-submit,
        .btn-cancel {
            justify-content: center;
        }
    }

    /* Animations */
    @keyframes fadeIn {
        from {
            opacity: 0;
            transform: translateY(10px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    .readings-section,
    .calculation-preview {
        animation: fadeIn 0.5s ease;
    }
</style>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Add real-time calculation if current readings change
        const currentInput = document.querySelector('.current-input');
        if (currentInput) {
            currentInput.addEventListener('input', function() {
                if (this.value.length > 0) {
                    setTimeout(() => {
                        document.getElementById('calculate-btn').click();
                    }, 500);
                }
            });
        }

        // Add focus effects
        const inputs = document.querySelectorAll('.form-input');
        inputs.forEach(input => {
            input.addEventListener('focus', function() {
                this.parentNode.classList.add('focused');
            });

            input.addEventListener('blur', function() {
                this.parentNode.classList.remove('focused');
            });
        });
    });
</script>