<?php

/** @var yii\web\View $this */
/** @var string $content */

use app\assets\AppAsset;
use app\widgets\Alert;
use yii\bootstrap5\Breadcrumbs;
use yii\bootstrap5\Html;
use yii\bootstrap5\Nav;
use yii\bootstrap5\NavBar;

AppAsset::register($this);

$this->registerCsrfMetaTags();
$this->registerMetaTag(['charset' => Yii::$app->charset], 'charset');
$this->registerMetaTag(['name' => 'viewport', 'content' => 'width=device-width, initial-scale=1, shrink-to-fit=no']);
$this->registerMetaTag(['name' => 'description', 'content' => $this->params['meta_description'] ?? '']);
$this->registerMetaTag(['name' => 'keywords', 'content' => $this->params['meta_keywords'] ?? '']);
$this->registerLinkTag(['rel' => 'icon', 'type' => 'image/x-icon', 'href' => Yii::getAlias('@web/favicon.ico')]);
?>
<?php $this->beginPage() ?>
<!DOCTYPE html>
<html lang="<?= Yii::$app->language ?>" class="h-100">
<head>
    <title><?= Html::encode($this->title) ?></title>
    <?php $this->head() ?>
</head>
<body class="d-flex flex-column h-100">
<?php $this->beginBody() ?>

<header id="header">
    <?php
    NavBar::begin([
        'brandLabel' => Html::tag('span', 'Коммуналка', ['class' => 'brand-text']),
        'brandUrl' => Yii::$app->homeUrl,
        'options' => ['class' => 'navbar-expand-md navbar-custom fixed-top'],
        'brandOptions' => ['class' => 'navbar-brand-custom']
    ]);

    echo Nav::widget([
        'options' => ['class' => 'navbar-nav ms-auto'],
        'items' => [
            [
                'label' => 'Главная',
                'url' => ['/site/index'],
                'linkOptions' => ['class' => 'nav-link-custom']
            ],
            [
                'label' => 'Заявки',
                'url' => ['/application/index'],
                'visible' => !Yii::$app->user->isGuest,
                'linkOptions' => ['class' => 'nav-link-custom']
            ],
            [
                'label' => 'Передача показаний',
                'url' => ['/application/create'],
                'visible' => !Yii::$app->user->isGuest,
                'linkOptions' => ['class' => 'nav-link-custom highlight']
            ],
            [
                'label' => 'Регистрация',
                'url' => ['/site/register'],
                'visible' => Yii::$app->user->isGuest,
                'linkOptions' => ['class' => 'nav-link-custom']
            ],
            [
                'label' => 'Личный профиль клиента',
                'url' => ['/profile/index'],
                'visible' => !Yii::$app->user->isGuest,
                'linkOptions' => ['class' => 'nav-link-custom']
            ],
            [
                'label' => 'Админ-панель',
                'url' => ['/admin/index'],
                'visible' => !Yii::$app->user->isGuest && Yii::$app->user->identity->isAdmin(),
                'linkOptions' => ['class' => 'nav-link-custom admin']
            ],
            Yii::$app->user->isGuest
                ? [
                'label' => 'Авторизация',
                'url' => ['/site/login'],
                'linkOptions' => ['class' => 'nav-link-custom login']
            ]
                : '<li class="nav-item">'
                . Html::beginForm(['/site/logout'], 'post', ['class' => 'logout-form'])
                . Html::submitButton(
                    Html::tag('i', '', ['class' => 'fas fa-sign-out-alt']) .
                    'Выйти (' . Yii::$app->user->identity->first_name . ' ' . Yii::$app->user->identity->last_name . ')',
                    ['class' => 'nav-link-custom logout-btn']
                )
                . Html::endForm()
                . '</li>'
        ]
    ]);
    NavBar::end();
    ?>
</header>

<main id="main" class="flex-shrink-0" role="main">
    <div class="container-main">
        <?php if (!empty($this->params['breadcrumbs'])): ?>
            <div class="breadcrumbs-container">
                <?= Breadcrumbs::widget([
                    'links' => $this->params['breadcrumbs'],
                    'options' => ['class' => 'breadcrumbs-custom']
                ]) ?>
            </div>
        <?php endif ?>
        <div class="alert-container">
            <?= Alert::widget() ?>
        </div>
        <div class="content-wrapper">
            <?= $content ?>
        </div>
    </div>
</main>

<footer id="footer" class="mt-auto">
    <div class="footer-content">
        <div class="container">
            <div class="footer-section">
                <div class="footer-brand">
                    <div class="footer-logo">К</div>
                    <span class="footer-title">Коммуналка</span>
                </div>
                <p class="footer-description">Управление коммунальными услугами стало проще</p>
            </div>
            <div class="footer-section">
                <h4>Быстрые ссылки</h4>
                <ul class="footer-links">
                    <li><?= Html::a('Главная', ['/site/index']) ?></li>
                    <?php if (!Yii::$app->user->isGuest): ?>
                        <li><?= Html::a('Мои заявки', ['/application/index']) ?></li>
                        <li><?= Html::a('Передать показания', ['/application/create']) ?></li>
                    <?php endif; ?>
                </ul>
            </div>
            <div class="footer-section">
                <h4>Контакты</h4>
                <div class="contact-info">
                    <div class="contact-item">
                        <i class="fas fa-phone"></i>
                        <span>8 (800) 123-45-67</span>
                    </div>
                    <div class="contact-item">
                        <i class="fas fa-envelope"></i>
                        <span>support@kommunalka.ru</span>
                    </div>
                    <div class="contact-item">
                        <i class="fas fa-clock"></i>
                        <span>Пн-Пт: 9:00-18:00</span>
                    </div>
                </div>
            </div>
        </div>
        <div class="footer-bottom">
            <div class="container">
                <div class="footer-copyright">
                    <i class="far fa-copyright"></i>
                    Коммуналка <?= date('Y') ?> | Все права защищены
                </div>
            </div>
        </div>
    </div>
</footer>

<?php $this->endBody() ?>
</body>
</html>
<?php $this->endPage() ?>

<style>
    /* Global Styles */
    :root {
        --primary-gradient: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        --secondary-gradient: linear-gradient(45deg, #ff6b6b, #ee5a24);
        --accent-color: #667eea;
        --text-dark: #2c3e50;
        --text-light: #7f8c8d;
        --bg-light: #f8f9fa;
        --white: #ffffff;
        --shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
        --border-radius: 12px;
    }

    body {
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        background: var(--bg-light);
        color: var(--text-dark);
    }

    /* Header & Navigation */
    .navbar-custom {
        background: rgba(255, 255, 255, 0.95) !important;
        backdrop-filter: blur(20px);
        border-bottom: 1px solid rgba(255, 255, 255, 0.2);
        box-shadow: 0 2px 20px rgba(0, 0, 0, 0.1);
        padding: 0.8rem 0;
        transition: all 0.3s ease;
    }

    .navbar-brand-custom {
        display: flex;
        align-items: center;
        font-weight: 700;
        font-size: 1.5rem;
        background: var(--primary-gradient);
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
        background-clip: text;
        padding: 0.5rem 1rem;
        border-radius: var(--border-radius);
    }

    .brand-text {
        background: var(--primary-gradient);
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
        background-clip: text;
    }

    .navbar-nav {
        gap: 0.5rem;
    }

    .nav-link-custom {
        color: var(--text-dark) !important;
        font-weight: 500;
        padding: 0.75rem 1.25rem !important;
        border-radius: 25px;
        transition: all 0.3s ease;
        position: relative;
        border: none;
        background: transparent;
    }

    .nav-link-custom:hover {
        color: var(--accent-color) !important;
        background: rgba(102, 126, 234, 0.1);
        transform: translateY(-1px);
    }

    .nav-link-custom.highlight {
        background: var(--secondary-gradient);
        color: var(--white) !important;
        box-shadow: 0 4px 15px rgba(255, 107, 107, 0.4);
    }

    .nav-link-custom.highlight:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 20px rgba(255, 107, 107, 0.6);
    }

    .nav-link-custom.admin {
        background: linear-gradient(45deg, #27ae60, #2ecc71);
        color: var(--white) !important;
    }

    .nav-link-custom.login {
        background: var(--primary-gradient);
        color: var(--white) !important;
    }

    .logout-form {
        margin: 0;
    }

    .logout-btn {
        background: transparent !important;
        color: var(--text-dark) !important;
        border: 1px solid #e9ecef;
        cursor: pointer;
        font-weight: 500;
    }

    .logout-btn:hover {
        background: rgba(255, 107, 107, 0.1) !important;
        color: #ff6b6b !important;
        border-color: #ff6b6b;
    }

    .logout-btn i {
        margin-right: 0.5rem;
    }

    /* Main Content */
    .container-main {
        max-width: 1200px;
        margin: 0 auto;
        padding: 2rem 1rem;
        margin-top: 80px;
    }

    .breadcrumbs-container {
        margin-bottom: 2rem;
    }

    .breadcrumbs-custom {
        background: var(--white);
        padding: 1rem 1.5rem;
        border-radius: var(--border-radius);
        box-shadow: var(--shadow);
    }

    .breadcrumbs-custom .breadcrumb-item a {
        color: var(--accent-color);
        text-decoration: none;
        font-weight: 500;
    }

    .breadcrumbs-custom .breadcrumb-item.active {
        color: var(--text-light);
    }

    .alert-container {
        margin-bottom: 2rem;
    }

    .content-wrapper {
        background: var(--white);
        border-radius: var(--border-radius);
        box-shadow: var(--shadow);
        padding: 2rem;
        min-height: 400px;
    }

    /* Footer */
    #footer {
        background: linear-gradient(135deg, #2c3e50 0%, #34495e 100%);
        color: var(--white);
    }

    .footer-content {
        padding: 3rem 0 0;
    }

    .footer-content .container {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
        gap: 2rem;
        padding-bottom: 2rem;
    }

    .footer-section h4 {
        color: var(--white);
        margin-bottom: 1.5rem;
        font-weight: 600;
    }

    .footer-brand {
        display: flex;
        align-items: center;
        margin-bottom: 1rem;
    }

    .footer-logo {
        width: 40px;
        height: 40px;
        background: var(--secondary-gradient);
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-weight: bold;
        margin-right: 0.75rem;
    }

    .footer-title {
        font-size: 1.25rem;
        font-weight: 700;
    }

    .footer-description {
        color: rgba(255, 255, 255, 0.8);
        line-height: 1.6;
    }

    .footer-links {
        list-style: none;
        padding: 0;
        margin: 0;
    }

    .footer-links li {
        margin-bottom: 0.75rem;
    }

    .footer-links a {
        color: rgba(255, 255, 255, 0.8);
        text-decoration: none;
        transition: color 0.3s ease;
    }

    .footer-links a:hover {
        color: var(--white);
    }

    .contact-info {
        display: flex;
        flex-direction: column;
        gap: 1rem;
    }

    .contact-item {
        display: flex;
        align-items: center;
        color: rgba(255, 255, 255, 0.8);
    }

    .contact-item i {
        margin-right: 0.75rem;
        width: 20px;
        color: var(--accent-color);
    }

    .footer-bottom {
        border-top: 1px solid rgba(255, 255, 255, 0.1);
        padding: 1.5rem 0;
        background: rgba(0, 0, 0, 0.2);
    }

    .footer-copyright {
        text-align: center;
        color: rgba(255, 255, 255, 0.7);
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 0.5rem;
    }

    /* Responsive Design */
    @media (max-width: 768px) {
        .navbar-nav {
            text-align: center;
            padding: 1rem 0;
        }

        .nav-link-custom {
            padding: 1rem !important;
            margin: 0.25rem 0;
        }

        .container-main {
            margin-top: 70px;
            padding: 1rem;
        }

        .content-wrapper {
            padding: 1.5rem;
        }

        .footer-content .container {
            grid-template-columns: 1fr;
            text-align: center;
        }

        .footer-brand {
            justify-content: center;
        }

        .contact-item {
            justify-content: center;
        }
    }

    /* Animation for navbar on scroll */
    .navbar-scrolled {
        background: rgba(255, 255, 255, 0.98) !important;
        box-shadow: 0 5px 25px rgba(0, 0, 0, 0.15);
        padding: 0.5rem 0;
    }

    /* Smooth transitions */
    * {
        transition: color 0.3s ease, background-color 0.3s ease, border-color 0.3s ease;
    }
</style>

<script>
    // Add scroll effect to navbar
    window.addEventListener('scroll', function() {
        const navbar = document.querySelector('.navbar-custom');
        if (window.scrollY > 50) {
            navbar.classList.add('navbar-scrolled');
        } else {
            navbar.classList.remove('navbar-scrolled');
        }
    });

    // Add hover effects dynamically
    document.addEventListener('DOMContentLoaded', function() {
        const navLinks = document.querySelectorAll('.nav-link-custom');

        navLinks.forEach(link => {
            link.addEventListener('mouseenter', function() {
                this.style.transform = 'translateY(-2px)';
            });

            link.addEventListener('mouseleave', function() {
                this.style.transform = 'translateY(0)';
            });
        });
    });
</script>