<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\bootstrap5\Alert;

/** @var yii\web\View $this */
/** @var app\models\ProfileForm $model */

$this->title = 'Личный профиль';
$this->params['breadcrumbs'][] = $this->title;
?>

<div class="profile-index">
    <div class="profile-container">
        <div class="profile-header">
            <div class="header-avatar">
                <div class="avatar-circle">
                    <i class="fas fa-user"></i>
                </div>
            </div>
            <div class="header-content">
                <h1 class="page-title"><?= Html::encode($this->title) ?></h1>
                <p class="page-subtitle">Управление вашими персональными данными и настройками</p>
            </div>
        </div>

        <div class="profile-card">
            <div class="card-body">
                <?php $form = ActiveForm::begin([
                    'id' => 'profile-form',
                    'options' => ['class' => 'profile-form']
                ]); ?>

                <div class="form-section">
                    <div class="section-header">
                        <div class="section-icon">
                            <i class="fas fa-user-circle"></i>
                        </div>
                        <h3>Основная информация</h3>
                    </div>

                    <div class="form-grid">
                        <div class="form-group">
                            <?= $form->field($model, 'last_name', [
                                'template' => '
                                    <div class="input-group">
                                        <span class="input-icon">
                                            <i class="fas fa-user"></i>
                                        </span>
                                        {input}
                                    </div>
                                    {label}
                                    {error}
                                ',
                                'labelOptions' => ['class' => 'form-label'],
                                'inputOptions' => [
                                    'class' => 'form-input',
                                    'placeholder' => 'Введите фамилию'
                                ]
                            ])->textInput(['maxlength' => true]) ?>
                        </div>

                        <div class="form-group">
                            <?= $form->field($model, 'first_name', [
                                'template' => '
                                    <div class="input-group">
                                        <span class="input-icon">
                                            <i class="fas fa-user"></i>
                                        </span>
                                        {input}
                                    </div>
                                    {label}
                                    {error}
                                ',
                                'labelOptions' => ['class' => 'form-label'],
                                'inputOptions' => [
                                    'class' => 'form-input',
                                    'placeholder' => 'Введите имя'
                                ]
                            ])->textInput(['maxlength' => true]) ?>
                        </div>

                        <div class="form-group">
                            <?= $form->field($model, 'patronymic', [
                                'template' => '
                                    <div class="input-group">
                                        <span class="input-icon">
                                            <i class="fas fa-user"></i>
                                        </span>
                                        {input}
                                    </div>
                                    {label}
                                    {error}
                                ',
                                'labelOptions' => ['class' => 'form-label'],
                                'inputOptions' => [
                                    'class' => 'form-input',
                                    'placeholder' => 'Введите отчество'
                                ]
                            ])->textInput(['maxlength' => true]) ?>
                        </div>

                        <div class="form-group">
                            <?= $form->field($model, 'phone', [
                                'template' => '
                                    <div class="input-group">
                                        <span class="input-icon">
                                            <i class="fas fa-phone"></i>
                                        </span>
                                        {input}
                                    </div>
                                    {label}
                                    {error}
                                ',
                                'labelOptions' => ['class' => 'form-label'],
                                'inputOptions' => [
                                    'class' => 'form-input',
                                    'placeholder' => 'Введите номер телефона'
                                ]
                            ])->textInput(['maxlength' => true]) ?>
                        </div>

                        <div class="form-group">
                            <?= $form->field($model, 'count', [
                                'template' => '
                                    <div class="input-group">
                                        <span class="input-icon">
                                            <i class="fas fa-users"></i>
                                        </span>
                                        {input}
                                    </div>
                                    {label}
                                    {error}
                                ',
                                'labelOptions' => ['class' => 'form-label'],
                                'inputOptions' => [
                                    'class' => 'form-input',
                                    'placeholder' => 'Количество проживающих',
                                    'type' => 'number',
                                    'min' => '1'
                                ]
                            ])->textInput(['type' => 'number']) ?>
                        </div>

                        <div class="form-group">
                            <?= $form->field($model, 'email', [
                                'template' => '
                                    <div class="input-group">
                                        <span class="input-icon">
                                            <i class="fas fa-envelope"></i>
                                        </span>
                                        {input}
                                    </div>
                                    {label}
                                    {error}
                                ',
                                'labelOptions' => ['class' => 'form-label'],
                                'inputOptions' => [
                                    'class' => 'form-input',
                                    'placeholder' => 'Введите email'
                                ]
                            ])->textInput(['maxlength' => true]) ?>
                        </div>
                    </div>

                    <div class="form-group-full">
                        <?= $form->field($model, 'address', [
                            'template' => '
                                <div class="textarea-group">
                                    <span class="textarea-icon">
                                        <i class="fas fa-home"></i>
                                    </span>
                                    {input}
                                </div>
                                {label}
                                {error}
                            ',
                            'labelOptions' => ['class' => 'form-label'],
                            'inputOptions' => [
                                'class' => 'form-textarea',
                                'placeholder' => 'Введите ваш полный адрес',
                                'rows' => 3
                            ]
                        ])->textarea(['rows' => 3]) ?>
                    </div>
                </div>

                <div class="form-section password-section">
                    <div class="section-header">
                        <div class="section-icon">
                            <i class="fas fa-lock"></i>
                        </div>
                        <div class="section-title">
                            <h3>Смена пароля</h3>
                            <p class="section-subtitle">Заполняйте эти поля только если хотите сменить пароль</p>
                        </div>
                    </div>

                    <div class="password-grid">
                        <div class="form-group">
                            <?= $form->field($model, 'current_password', [
                                'template' => '
                                    <div class="input-group">
                                        <span class="input-icon">
                                            <i class="fas fa-key"></i>
                                        </span>
                                        {input}
                                        <button type="button" class="password-toggle" onclick="togglePassword(\'' . Html::getInputId($model, 'current_password') . '\')">
                                            <i class="fas fa-eye"></i>
                                        </button>
                                    </div>
                                    {label}
                                    {error}
                                ',
                                'labelOptions' => ['class' => 'form-label'],
                                'inputOptions' => [
                                    'class' => 'form-input password-input',
                                    'placeholder' => 'Введите текущий пароль'
                                ]
                            ])->passwordInput(['maxlength' => true]) ?>
                        </div>

                        <div class="form-group">
                            <?= $form->field($model, 'new_password', [
                                'template' => '
                                    <div class="input-group">
                                        <span class="input-icon">
                                            <i class="fas fa-lock"></i>
                                        </span>
                                        {input}
                                        <button type="button" class="password-toggle" onclick="togglePassword(\'' . Html::getInputId($model, 'new_password') . '\')">
                                            <i class="fas fa-eye"></i>
                                        </button>
                                    </div>
                                    {label}
                                    {error}
                                ',
                                'labelOptions' => ['class' => 'form-label'],
                                'inputOptions' => [
                                    'class' => 'form-input password-input',
                                    'placeholder' => 'Введите новый пароль'
                                ]
                            ])->passwordInput(['maxlength' => true]) ?>
                        </div>

                        <div class="form-group">
                            <?= $form->field($model, 'confirm_password', [
                                'template' => '
                                    <div class="input-group">
                                        <span class="input-icon">
                                            <i class="fas fa-lock"></i>
                                        </span>
                                        {input}
                                        <button type="button" class="password-toggle" onclick="togglePassword(\'' . Html::getInputId($model, 'confirm_password') . '\')">
                                            <i class="fas fa-eye"></i>
                                        </button>
                                    </div>
                                    {label}
                                    {error}
                                ',
                                'labelOptions' => ['class' => 'form-label'],
                                'inputOptions' => [
                                    'class' => 'form-input password-input',
                                    'placeholder' => 'Повторите новый пароль'
                                ]
                            ])->passwordInput(['maxlength' => true]) ?>
                        </div>
                    </div>
                </div>

                <div class="form-actions">
                    <?= Html::submitButton('<i class="fas fa-save"></i> Сохранить изменения', [
                        'class' => 'btn-save',
                        'name' => 'profile-button'
                    ]) ?>
                    <?= Html::a('<i class="fas fa-times"></i> Отмена', ['site/index'], ['class' => 'btn-cancel']) ?>
                </div>

                <?php ActiveForm::end(); ?>
            </div>
        </div>
    </div>
</div>

<style>
    /* Main Container */
    .profile-index {
        min-height: 100vh;
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        padding: 2rem 1rem;
    }

    .profile-container {
        max-width: 1000px;
        margin: 0 auto;
    }

    /* Header */
    .profile-header {
        display: flex;
        align-items: center;
        gap: 2rem;
        margin-bottom: 2rem;
    }

    .header-avatar {
        flex-shrink: 0;
    }

    .avatar-circle {
        width: 100px;
        height: 100px;
        background: rgba(255, 255, 255, 0.2);
        backdrop-filter: blur(10px);
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        font-size: 2.5rem;
        border: 3px solid rgba(255, 255, 255, 0.3);
    }

    .header-content {
        flex: 1;
    }

    .page-title {
        font-size: 2.5rem;
        font-weight: 700;
        color: white;
        margin: 0 0 0.5rem 0;
    }

    .page-subtitle {
        color: rgba(255, 255, 255, 0.9);
        font-size: 1.1rem;
        margin: 0;
    }

    /* Card */
    .profile-card {
        background: rgba(255, 255, 255, 0.95);
        backdrop-filter: blur(20px);
        border-radius: 24px;
        box-shadow: 0 20px 60px rgba(0, 0, 0, 0.2);
        overflow: hidden;
    }

    .card-body {
        padding: 2.5rem;
    }

    /* Form Sections */
    .form-section {
        margin-bottom: 2.5rem;
    }

    .section-header {
        display: flex;
        align-items: flex-start;
        gap: 1rem;
        margin-bottom: 2rem;
        padding-bottom: 1rem;
        border-bottom: 1px solid #e8eeff;
    }

    .section-icon {
        width: 50px;
        height: 50px;
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        font-size: 1.25rem;
        flex-shrink: 0;
    }

    .section-header h3 {
        margin: 0;
        color: #2c3e50;
        font-size: 1.5rem;
    }

    .section-title {
        flex: 1;
    }

    .section-subtitle {
        color: #7f8c8d;
        font-size: 0.95rem;
        margin: 0.25rem 0 0 0;
    }

    /* Form Grid */
    .form-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
        gap: 1.5rem;
        margin-bottom: 1.5rem;
    }

    .password-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
        gap: 1.5rem;
    }

    .form-group {
        margin-bottom: 0;
    }

    .form-group-full {
        margin-bottom: 0;
    }

    /* Input Styles */
    .input-group {
        position: relative;
        display: flex;
        align-items: center;
    }

    .textarea-group {
        position: relative;
    }

    .input-icon, .textarea-icon {
        position: absolute;
        left: 1rem;
        z-index: 2;
        color: #667eea;
        font-size: 1rem;
    }

    .textarea-icon {
        top: 1rem;
        transform: none;
    }

    .form-input {
        width: 100%;
        padding: 1rem 1rem 1rem 3rem;
        border: 2px solid #e8eeff;
        border-radius: 12px;
        font-size: 1rem;
        background: #f8faff;
        transition: all 0.3s ease;
        outline: none;
    }

    .form-input:focus {
        border-color: #667eea;
        background: white;
        box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
        transform: translateY(-1px);
    }

    .form-input::placeholder {
        color: #a0a4c1;
    }

    .form-textarea {
        width: 100%;
        padding: 1rem 1rem 1rem 3rem;
        border: 2px solid #e8eeff;
        border-radius: 12px;
        font-size: 1rem;
        background: #f8faff;
        transition: all 0.3s ease;
        outline: none;
        resize: vertical;
        min-height: 100px;
        font-family: inherit;
    }

    .form-textarea:focus {
        border-color: #667eea;
        background: white;
        box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
    }

    .form-label {
        display: block;
        margin-bottom: 0.5rem;
        font-weight: 600;
        color: #2c3e50;
        font-size: 0.95rem;
    }

    .form-label.required::after {
        content: ' *';
        color: #ff4757;
    }

    /* Password Inputs */
    .password-input {
        padding-right: 3rem;
    }

    .password-toggle {
        position: absolute;
        right: 1rem;
        background: none;
        border: none;
        color: #a0a4c1;
        cursor: pointer;
        font-size: 1rem;
        transition: color 0.3s ease;
        z-index: 2;
    }

    .password-toggle:hover {
        color: #667eea;
    }

    /* Password Section */
    .password-section {
        background: #f8faff;
        border: 1px solid #e8eeff;
        border-radius: 16px;
        padding: 2rem;
        margin: 2.5rem 0;
    }

    .password-section .section-header {
        border-bottom: none;
        margin-bottom: 1.5rem;
        padding-bottom: 0;
    }

    /* Form Actions */
    .form-actions {
        display: flex;
        gap: 1rem;
        justify-content: flex-end;
        margin-top: 2rem;
        padding-top: 2rem;
        border-top: 1px solid #e8eeff;
    }

    .btn-save {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
        border: none;
        padding: 1rem 2rem;
        font-size: 1.1rem;
        font-weight: 600;
        border-radius: 12px;
        cursor: pointer;
        transition: all 0.3s ease;
        box-shadow: 0 4px 15px rgba(102, 126, 234, 0.4);
        display: flex;
        align-items: center;
        gap: 0.5rem;
    }

    .btn-save:hover {
        transform: translateY(-2px);
        box-shadow: 0 8px 25px rgba(102, 126, 234, 0.6);
    }

    .btn-cancel {
        background: white;
        color: #667eea;
        border: 2px solid #667eea;
        padding: 1rem 2rem;
        font-size: 1.1rem;
        font-weight: 600;
        border-radius: 12px;
        cursor: pointer;
        transition: all 0.3s ease;
        text-decoration: none;
        display: flex;
        align-items: center;
        gap: 0.5rem;
    }

    .btn-cancel:hover {
        background: #667eea;
        color: white;
        transform: translateY(-2px);
        text-decoration: none;
    }

    /* Error States */
    .has-error .form-input,
    .has-error .form-textarea {
        border-color: #ff4757;
        background: rgba(255, 71, 87, 0.05);
    }

    .has-error .form-input:focus,
    .has-error .form-textarea:focus {
        border-color: #ff4757;
        box-shadow: 0 0 0 3px rgba(255, 71, 87, 0.1);
    }

    .help-block {
        color: #ff4757;
        font-size: 0.875rem;
        margin-top: 0.5rem;
        display: block;
    }

    /* Responsive Design */
    @media (max-width: 768px) {
        .profile-header {
            flex-direction: column;
            text-align: center;
            gap: 1rem;
        }

        .page-title {
            font-size: 2rem;
        }

        .card-body {
            padding: 1.5rem;
        }

        .section-header {
            flex-direction: column;
            text-align: center;
            gap: 1rem;
        }

        .form-grid,
        .password-grid {
            grid-template-columns: 1fr;
        }

        .form-actions {
            flex-direction: column;
        }

        .btn-save,
        .btn-cancel {
            justify-content: center;
        }

        .password-section {
            padding: 1.5rem;
            margin: 2rem 0;
        }
    }

    /* Animations */
    @keyframes fadeInUp {
        from {
            opacity: 0;
            transform: translateY(20px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    .form-section {
        animation: fadeInUp 0.5s ease;
    }

    .form-group {
        animation: fadeInUp 0.3s ease;
    }

    /* Password Strength Indicator */
    .password-strength {
        margin-top: 0.5rem;
        height: 4px;
        border-radius: 2px;
        background: #e8eeff;
        overflow: hidden;
    }

    .password-strength-bar {
        height: 100%;
        transition: all 0.3s ease;
        border-radius: 2px;
    }

    .password-strength.weak .password-strength-bar {
        background: #ff4757;
        width: 33%;
    }

    .password-strength.medium .password-strength-bar {
        background: #ffa502;
        width: 66%;
    }

    .password-strength.strong .password-strength-bar {
        background: #2ed573;
        width: 100%;
    }
</style>

<script>
    function togglePassword(inputId) {
        const input = document.getElementById(inputId);
        const icon = input.parentNode.querySelector('.password-toggle i');

        if (input.type === 'password') {
            input.type = 'text';
            icon.classList.remove('fa-eye');
            icon.classList.add('fa-eye-slash');
        } else {
            input.type = 'password';
            icon.classList.remove('fa-eye-slash');
            icon.classList.add('fa-eye');
        }
    }

    document.addEventListener('DOMContentLoaded', function() {
        // Dynamic required fields for password change
        const currentPasswordField = document.getElementById('profileform-current_password');
        const newPasswordLabels = document.querySelectorAll('#profileform-new_password, #profileform-confirm_password')
            .forEach(field => {
                const label = field.closest('.form-group').querySelector('.form-label');
                if (label) {
                    label.classList.remove('required');
                }
            });

        if (currentPasswordField) {
            currentPasswordField.addEventListener('input', function() {
                const newPasswordLabel = document.querySelector('[for="profileform-new_password"]');
                const confirmPasswordLabel = document.querySelector('[for="profileform-confirm_password"]');

                if (this.value !== '') {
                    if (newPasswordLabel) newPasswordLabel.classList.add('required');
                    if (confirmPasswordLabel) confirmPasswordLabel.classList.add('required');
                } else {
                    if (newPasswordLabel) newPasswordLabel.classList.remove('required');
                    if (confirmPasswordLabel) confirmPasswordLabel.classList.remove('required');
                }
            });
        }

        // Add focus effects
        const inputs = document.querySelectorAll('.form-input, .form-textarea');
        inputs.forEach(input => {
            input.addEventListener('focus', function() {
                this.parentNode.classList.add('focused');
            });

            input.addEventListener('blur', function() {
                this.parentNode.classList.remove('focused');
            });
        });

        // Add real-time password strength check
        const newPasswordField = document.getElementById('profileform-new_password');
        if (newPasswordField) {
            newPasswordField.addEventListener('input', function() {
                checkPasswordStrength(this.value);
            });
        }
    });

    function checkPasswordStrength(password) {
        const strengthBar = document.querySelector('.password-strength-bar');
        const strengthContainer = document.querySelector('.password-strength');

        if (!strengthBar || !strengthContainer) return;

        let strength = 0;

        if (password.length >= 8) strength++;
        if (password.match(/[a-z]/) && password.match(/[A-Z]/)) strength++;
        if (password.match(/\d/)) strength++;
        if (password.match(/[^a-zA-Z\d]/)) strength++;

        strengthContainer.className = 'password-strength';

        if (password.length === 0) {
            strengthBar.style.width = '0%';
        } else if (strength <= 1) {
            strengthContainer.classList.add('weak');
        } else if (strength <= 3) {
            strengthContainer.classList.add('medium');
        } else {
            strengthContainer.classList.add('strong');
        }
    }
</script>