<?php

/** @var yii\web\View $this */
/** @var yii\bootstrap5\ActiveForm $form */

/** @var app\models\LoginForm $model */

use yii\bootstrap5\ActiveForm;
use yii\bootstrap5\Html;

$this->title = 'Регистрация';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="site-register">
    <div class="register-container">
        <div class="register-header">
            <div class="register-icon">
                <i class="fas fa-user-plus"></i>
            </div>
            <h1 class="register-title"><?= Html::encode($this->title) ?></h1>
            <p class="register-subtitle">Создайте аккаунт для управления коммунальными услугами</p>
        </div>

        <div class="register-form-container">
            <?php $form = ActiveForm::begin([
                'id' => 'register-form',
                'options' => ['class' => 'register-form'],
                'fieldConfig' => [
                    'template' => "{label}\n{input}\n{error}",
                    'labelOptions' => ['class' => 'form-label'],
                    'inputOptions' => ['class' => 'form-input'],
                    'errorOptions' => ['class' => 'form-error'],
                ],
            ]); ?>

            <div class="form-grid">
                <div class="form-group">
                    <?= $form->field($model, 'first_name', [
                        'template' => '
                            <div class="input-group">
                                <span class="input-icon">
                                    <i class="fas fa-user"></i>
                                </span>
                                {input}
                            </div>
                            {error}
                        ',
                        'inputOptions' => [
                            'class' => 'form-input',
                            'placeholder' => 'Введите ваше имя'
                        ]
                    ])->textInput(['autofocus' => true]) ?>
                </div>

                <div class="form-group">
                    <?= $form->field($model, 'last_name', [
                        'template' => '
                            <div class="input-group">
                                <span class="input-icon">
                                    <i class="fas fa-user"></i>
                                </span>
                                {input}
                            </div>
                            {error}
                        ',
                        'inputOptions' => [
                            'class' => 'form-input',
                            'placeholder' => 'Введите вашу фамилию'
                        ]
                    ])->textInput() ?>
                </div>

                <div class="form-group">
                    <?= $form->field($model, 'patronymic', [
                        'template' => '
                            <div class="input-group">
                                <span class="input-icon">
                                    <i class="fas fa-user"></i>
                                </span>
                                {input}
                            </div>
                            {error}
                        ',
                        'inputOptions' => [
                            'class' => 'form-input',
                            'placeholder' => 'Введите ваше отчество'
                        ]
                    ])->textInput() ?>
                </div>

                <div class="form-group">
                    <?= $form->field($model, 'phone', [
                        'template' => '
                            <div class="input-group">
                                <span class="input-icon">
                                    <i class="fas fa-phone"></i>
                                </span>
                                {input}
                            </div>
                            {error}
                        ',
                        'inputOptions' => [
                            'class' => 'form-input',
                            'placeholder' => '8(999)999-99-99'
                        ]
                    ])->widget(\yii\widgets\MaskedInput::class, [
                        'mask' => '8(999)999-99-99',
                    ]) ?>
                </div>

                <div class="form-group">
                    <?= $form->field($model, 'email', [
                        'template' => '
                            <div class="input-group">
                                <span class="input-icon">
                                    <i class="fas fa-envelope"></i>
                                </span>
                                {input}
                            </div>
                            {error}
                        ',
                        'inputOptions' => [
                            'class' => 'form-input',
                            'placeholder' => 'Введите ваш email'
                        ]
                    ])->textInput() ?>
                </div>

                <div class="form-group">
                    <?= $form->field($model, 'address', [
                        'template' => '
                            <div class="input-group">
                                <span class="input-icon">
                                    <i class="fas fa-home"></i>
                                </span>
                                {input}
                            </div>
                            {error}
                        ',
                        'inputOptions' => [
                            'class' => 'form-input',
                            'placeholder' => 'Введите ваш адрес'
                        ]
                    ])->textInput() ?>
                </div>

                <div class="form-group">
                    <?= $form->field($model, 'count', [
                        'template' => '
                            <div class="input-group">
                                <span class="input-icon">
                                    <i class="fas fa-hashtag"></i>
                                </span>
                                {input}
                            </div>
                            {error}
                        ',
                        'inputOptions' => [
                            'class' => 'form-input',
                            'placeholder' => 'Количество проживающих',
                            'type' => 'number',
                            'min' => '1'
                        ]
                    ])->textInput(['type' => 'number']) ?>
                </div>

                <div class="form-group">
                    <?= $form->field($model, 'password', [
                        'template' => '
                            <div class="input-group">
                                <span class="input-icon">
                                    <i class="fas fa-lock"></i>
                                </span>
                                {input}
                                <button type="button" class="password-toggle" onclick="togglePassword(\'' . Html::getInputId($model, 'password') . '\')">
                                    <i class="fas fa-eye"></i>
                                </button>
                            </div>
                            {error}
                        ',
                        'inputOptions' => [
                            'class' => 'form-input',
                            'placeholder' => 'Создайте пароль'
                        ]
                    ])->passwordInput() ?>
                </div>

                <div class="form-group">
                    <?= $form->field($model, 'password_repeat', [
                        'template' => '
                            <div class="input-group">
                                <span class="input-icon">
                                    <i class="fas fa-lock"></i>
                                </span>
                                {input}
                                <button type="button" class="password-toggle" onclick="togglePassword(\'' . Html::getInputId($model, 'password_repeat') . '\')">
                                    <i class="fas fa-eye"></i>
                                </button>
                            </div>
                            {error}
                        ',
                        'inputOptions' => [
                            'class' => 'form-input',
                            'placeholder' => 'Повторите пароль'
                        ]
                    ])->passwordInput() ?>
                </div>
            </div>

            <div class="form-checkbox-group">
                <?= $form->field($model, 'rules')->checkbox([
                    'template' => "
                        <div class=\"checkbox-container\">
                            <label class=\"checkbox-label\">
                                {input}
                                <span class=\"checkbox-custom\"></span>
                                <span class=\"checkbox-text\">Я соглашаюсь с условиями использования и политикой конфиденциальности</span>
                            </label>
                        </div>
                        <div class=\"checkbox-error\">{error}</div>
                    ",
                    'class' => 'checkbox-input'
                ]) ?>
            </div>

            <div class="form-actions">
                <?= Html::submitButton('Создать пользователя', [
                    'class' => 'btn-register',
                    'name' => 'register-button'
                ]) ?>
            </div>

            <div class="form-footer">
                <p class="login-link">
                    Уже зарегистрированы?
                    <?= Html::a('Авторизоваться', ['site/login'], ['class' => 'login-link-text']) ?>
                </p>
            </div>

            <?php ActiveForm::end(); ?>
        </div>
    </div>
</div>

<style>
    /* Register Container */
    .site-register {
        min-height: 100vh;
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        display: flex;
        align-items: center;
        justify-content: center;
        padding: 2rem 1rem;
    }

    .register-container {
        background: rgba(255, 255, 255, 0.95);
        backdrop-filter: blur(20px);
        border-radius: 24px;
        box-shadow: 0 20px 60px rgba(0, 0, 0, 0.2);
        overflow: hidden;
        max-width: 900px;
        width: 100%;
    }

    .register-header {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
        padding: 3rem 2rem;
        text-align: center;
        position: relative;
    }

    .register-header::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1000 1000"><polygon fill="rgba(255,255,255,0.1)" points="0,1000 1000,500 1000,1000"/></svg>');
    }

    .register-icon {
        position: relative;
        z-index: 2;
        font-size: 3rem;
        margin-bottom: 1rem;
    }

    .register-title {
        position: relative;
        z-index: 2;
        font-size: 2.5rem;
        font-weight: 700;
        margin-bottom: 0.5rem;
    }

    .register-subtitle {
        position: relative;
        z-index: 2;
        font-size: 1.1rem;
        opacity: 0.9;
        margin: 0;
    }

    /* Form Styles */
    .register-form-container {
        padding: 3rem 2rem;
    }

    .form-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
        gap: 1.5rem;
        margin-bottom: 2rem;
    }

    .form-group {
        margin-bottom: 0;
    }

    .input-group {
        position: relative;
        display: flex;
        align-items: center;
    }

    .input-icon {
        position: absolute;
        left: 1rem;
        z-index: 2;
        color: #667eea;
        font-size: 1rem;
    }

    .form-input {
        width: 100%;
        padding: 1rem 1rem 1rem 3rem;
        border: 2px solid #e8eeff;
        border-radius: 12px;
        font-size: 1rem;
        background: #f8faff;
        transition: all 0.3s ease;
        outline: none;
    }

    .form-input:focus {
        border-color: #667eea;
        background: white;
        box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
        transform: translateY(-2px);
    }

    .form-input::placeholder {
        color: #a0a4c1;
    }

    .password-toggle {
        position: absolute;
        right: 1rem;
        background: none;
        border: none;
        color: #a0a4c1;
        cursor: pointer;
        font-size: 1rem;
        transition: color 0.3s ease;
        z-index: 2;
    }

    .password-toggle:hover {
        color: #667eea;
    }

    .form-error {
        color: #ff4757;
        font-size: 0.875rem;
        margin-top: 0.5rem;
        display: block;
    }

    /* Checkbox Styles */
    .form-checkbox-group {
        margin: 2rem 0;
    }

    .checkbox-container {
        display: flex;
        align-items: flex-start;
    }

    .checkbox-label {
        display: flex;
        align-items: flex-start;
        cursor: pointer;
        font-size: 0.95rem;
        color: #4a5568;
        line-height: 1.5;
    }

    .checkbox-input {
        display: none;
    }

    .checkbox-custom {
        width: 20px;
        height: 20px;
        border: 2px solid #e2e8f0;
        border-radius: 6px;
        margin-right: 0.75rem;
        margin-top: 0.125rem;
        position: relative;
        transition: all 0.3s ease;
        flex-shrink: 0;
    }

    .checkbox-input:checked + .checkbox-custom {
        background: linear-gradient(135deg, #667eea, #764ba2);
        border-color: #667eea;
    }

    .checkbox-input:checked + .checkbox-custom::after {
        content: '✓';
        position: absolute;
        color: white;
        font-size: 0.75rem;
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%);
    }

    .checkbox-text {
        flex: 1;
    }

    .checkbox-error {
        color: #ff4757;
        font-size: 0.875rem;
        margin-top: 0.5rem;
    }

    /* Button Styles */
    .form-actions {
        text-align: center;
        margin: 2rem 0;
    }

    .btn-register {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
        border: none;
        padding: 1.25rem 3rem;
        font-size: 1.1rem;
        font-weight: 600;
        border-radius: 50px;
        cursor: pointer;
        transition: all 0.3s ease;
        box-shadow: 0 10px 30px rgba(102, 126, 234, 0.4);
        position: relative;
        overflow: hidden;
    }

    .btn-register::before {
        content: '';
        position: absolute;
        top: 0;
        left: -100%;
        width: 100%;
        height: 100%;
        background: linear-gradient(90deg, transparent, rgba(255,255,255,0.3), transparent);
        transition: left 0.5s;
    }

    .btn-register:hover::before {
        left: 100%;
    }

    .btn-register:hover {
        transform: translateY(-3px);
        box-shadow: 0 15px 40px rgba(102, 126, 234, 0.6);
    }

    .btn-register:active {
        transform: translateY(-1px);
    }

    /* Footer Links */
    .form-footer {
        text-align: center;
        padding-top: 2rem;
        border-top: 1px solid #e8eeff;
    }

    .login-link {
        color: #718096;
        margin: 0;
    }

    .login-link-text {
        color: #667eea;
        text-decoration: none;
        font-weight: 600;
        transition: color 0.3s ease;
    }

    .login-link-text:hover {
        color: #764ba2;
        text-decoration: underline;
    }

    /* Responsive Design */
    @media (max-width: 768px) {
        .register-container {
            margin: 1rem;
        }

        .register-header {
            padding: 2rem 1.5rem;
        }

        .register-form-container {
            padding: 2rem 1.5rem;
        }

        .form-grid {
            grid-template-columns: 1fr;
            gap: 1rem;
        }

        .register-title {
            font-size: 2rem;
        }

        .btn-register {
            width: 100%;
            padding: 1.25rem 2rem;
        }
    }

    /* Animation for form elements */
    @keyframes fadeInUp {
        from {
            opacity: 0;
            transform: translateY(20px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    .form-group {
        animation: fadeInUp 0.5s ease forwards;
    }

    .form-group:nth-child(1) { animation-delay: 0.1s; }
    .form-group:nth-child(2) { animation-delay: 0.2s; }
    .form-group:nth-child(3) { animation-delay: 0.3s; }
    .form-group:nth-child(4) { animation-delay: 0.4s; }
    .form-group:nth-child(5) { animation-delay: 0.5s; }
    .form-group:nth-child(6) { animation-delay: 0.6s; }
    .form-group:nth-child(7) { animation-delay: 0.7s; }
    .form-group:nth-child(8) { animation-delay: 0.8s; }
    .form-group:nth-child(9) { animation-delay: 0.9s; }
</style>

<script>
    function togglePassword(inputId) {
        const input = document.getElementById(inputId);
        const icon = input.parentNode.querySelector('.password-toggle i');

        if (input.type === 'password') {
            input.type = 'text';
            icon.classList.remove('fa-eye');
            icon.classList.add('fa-eye-slash');
        } else {
            input.type = 'password';
            icon.classList.remove('fa-eye-slash');
            icon.classList.add('fa-eye');
        }
    }

    // Add focus effects
    document.addEventListener('DOMContentLoaded', function() {
        const inputs = document.querySelectorAll('.form-input');

        inputs.forEach(input => {
            input.addEventListener('focus', function() {
                this.parentNode.classList.add('focused');
            });

            input.addEventListener('blur', function() {
                this.parentNode.classList.remove('focused');
            });
        });
    });
</script>